/*
 * Decompiled with CFR 0.152.
 */
package com.powerutils;

import com.denfop.api.energy.networking.EnergyNetGlobal;
import com.denfop.containermenu.ContainerMenuBase;
import com.denfop.network.packet.PacketUpdateServerTile;
import com.denfop.screen.ScreenIndustrialUpgrade;
import com.denfop.utils.Localization;
import com.denfop.utils.ModUtils;
import com.mojang.blaze3d.systems.RenderSystem;
import com.powerutils.BlockEntityQEConverter;
import com.powerutils.ContainerMenuQEConverter;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;

public class ScreenQEConverter<T extends ContainerMenuQEConverter>
extends ScreenIndustrialUpgrade<ContainerMenuQEConverter> {
    private static final ResourceLocation background = ResourceLocation.tryBuild((String)"powerutils", (String)"textures/gui/ec4_gui.png");
    private final ContainerMenuQEConverter container;
    private final BlockEntityQEConverter tileentity;

    public ScreenQEConverter(ContainerMenuQEConverter container1) {
        super((ContainerMenuBase)container1);
        this.imageWidth = this.getXSize() - 1;
        this.imageHeight = 186;
        this.container = container1;
        this.tileentity = (BlockEntityQEConverter)container1.base;
    }

    protected void mouseClicked(int i, int j, int k) {
        super.mouseClicked(i, j, k);
        int xMin = this.guiLeft;
        int yMin = this.guiTop;
        int x = i - xMin;
        int y = j - yMin;
        if (x >= 39 && x < 59 && y >= 81 && y <= 91) {
            if (((BlockEntityQEConverter)this.container.base).rf) {
                new PacketUpdateServerTile((BlockEntity)this.container.base, 0.0);
            }
        } else if (x >= 59 && x < 79 && y >= 81 && y <= 91 && !((BlockEntityQEConverter)this.container.base).rf) {
            new PacketUpdateServerTile((BlockEntity)this.container.base, 0.0);
        }
    }

    protected ResourceLocation getTexture() {
        return background;
    }

    protected void drawForegroundLayer(GuiGraphics poseStack, int par1, int par2) {
        int nmPos = (this.imageWidth - this.getStringWidth(Localization.translate((String)((BlockEntityQEConverter)this.container.base).getName()))) / 2;
        this.drawString(poseStack, Localization.translate((String)((BlockEntityQEConverter)this.container.base).getName()), nmPos, 6, 7718655);
        this.drawString(poseStack, "EF: " + ModUtils.getString((double)this.tileentity.energy.getEnergy()) + "/" + ModUtils.getString((double)this.tileentity.energy.buffer.capacity), 9, 20, 0xCDCDCD);
        this.drawString(poseStack, "QE: " + ModUtils.getString((double)this.tileentity.energy2.getEnergy()) + "/" + ModUtils.getString((double)this.tileentity.energy2.buffer.capacity), 9, 30, 0xCDCDCD);
        if (this.tileentity.rf) {
            this.drawString(poseStack, "MAX IN: " + ModUtils.getString((double)EnergyNetGlobal.instance.getPowerFromTier(this.tileentity.tier)) + " EF/t", 9, 40, 0xCDCDCD);
            this.drawString(poseStack, "IN: " + ModUtils.getString((double)this.tileentity.differenceenergy1) + " EF/t", 9, 50, 0xCDCDCD);
            this.drawString(poseStack, "OUT: " + ModUtils.getString((double)Math.min(this.tileentity.differenceenergy, this.tileentity.energy2.getCapacity())) + " QE/t", 9, 60, 0xCDCDCD);
        } else {
            this.drawString(poseStack, "MAX OUT: " + ModUtils.getString((double)EnergyNetGlobal.instance.getPowerFromTier(this.tileentity.tier)) + " EF/t", 9, 40, 0xCDCDCD);
            this.drawString(poseStack, "IN: " + ModUtils.getString((double)this.tileentity.differenceenergy1) + " QE/t", 9, 50, 0xCDCDCD);
            this.drawString(poseStack, "OUT: " + ModUtils.getString((double)this.tileentity.differenceenergy) + " EF/t", 9, 60, 0xCDCDCD);
        }
    }

    protected void renderBg(GuiGraphics poseStack, float partialTicks, int mouseX, int mouseY) {
        int gaugeScaledHeight;
        int gaugeFullHeight;
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        ScreenQEConverter.bindTexture((ResourceLocation)background);
        int j = this.guiLeft;
        int k = this.guiTop;
        this.drawTexturedModalRect(poseStack, j, k, 0, 0, this.imageWidth, this.imageHeight);
        if (!this.tileentity.rf) {
            if (this.isHovering(39, 81, 20, 12, mouseX, mouseY)) {
                this.drawTexturedModalRect(poseStack, j + 39, k + 81, 197, 87, 20, 11);
            } else {
                this.drawTexturedModalRect(poseStack, j + 39, k + 81, 175, 87, 20, 11);
            }
            this.drawTexturedModalRect(poseStack, j + 118, k + 72, 175, 78, 7, 7);
        } else {
            if (this.isHovering(59, 81, 20, 12, mouseX, mouseY)) {
                this.drawTexturedModalRect(poseStack, j + 59, k + 81, 197, 87, 20, 11);
            } else {
                this.drawTexturedModalRect(poseStack, j + 59, k + 81, 175, 87, 20, 11);
            }
            this.drawTexturedModalRect(poseStack, j + 136, k + 72, 184, 78, 7, 7);
        }
        if (this.tileentity.energy.getEnergy() > 0.0) {
            gaugeFullHeight = 41;
            gaugeScaledHeight = this.tileentity.gaugeICEnergyScaled(gaugeFullHeight);
            this.drawTexturedModalRect(poseStack, j + 117, k + 70 - gaugeScaledHeight, 175, 76 - gaugeScaledHeight, 9, gaugeScaledHeight);
        }
        if (this.tileentity.energy2.getEnergy() > 0.0) {
            gaugeFullHeight = 41;
            gaugeScaledHeight = this.tileentity.gaugeTEEnergyScaled(gaugeFullHeight);
            this.drawTexturedModalRect(poseStack, j + 135, k + 70 - gaugeScaledHeight, 186, 76 - gaugeScaledHeight, 9, gaugeScaledHeight);
        }
    }
}

